(*********************************************
This demo draws the now famous "Doggie" bitmap
that comes with the WinG toolkit.  The unique
thing about this demo is that it illustrates the
use of a custom MoveProc.  The MoveProc used
here (MyMoveProc) simply positions the sprite
based on the current mouse coordinates.
*********************************************)
unit Doggie;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ColorPalette, ExtCtrls, TurboSprite, StdCtrls, Sprites, ColorPanel,
  ThreadTimer;

type
  TForm1 = class(TForm)
    ColorPalette1: TColorPalette;
    SpriteEngine1: TSpriteEngine;
    dibDoggie: TDIB;
    SpriteSurface1: TSpriteSurface;
    ThreadTimer1: TThreadTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure SpriteSurface1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure FormShow(Sender: TObject);
  private
  public
    X: integer;
    Y: integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  SpriteSurface1.DIBRefresh;
end;

procedure MyMoveProc( sprite: TSprite );
begin
  sprite.PositionX := Form1.X;
  sprite.PositionY := Form1.Y;
end;

procedure TForm1.SpriteSurface1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  self.X := X;
  self.Y := Y;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  ds: TDIBSprite;
begin
  ds := TDIBSprite.CreateDIBSprite( MyMoveProc, dibDoggie );
  SpriteEngine1.addSprite( ds );
end;

end.
